#include "metric_meta.h"

#include <util/stream/output.h>

namespace NMetabase {

bool operator==(const TMetricMeta& m1, const TMetricMeta& m2) {
    return m1.CreatedAt == m2.CreatedAt &&
        m1.Flags == m2.Flags &&
        m1.LocalId == m2.LocalId &&
        m1.ShardId == m2.ShardId &&
        m1.Labels == m2.Labels;
}

} // namespace NMetabase

template <>
void Out<NMetabase::TMetricMeta>(IOutputStream& out, const NMetabase::TMetricMeta& m) {
    out << "{Labels: \'" << m.Labels
        << "\', ShardId: " << m.ShardId
        << ", LocalId: " << m.LocalId
        << ", Flags: " << m.Flags
        << ", CreatedAt: " << m.CreatedAt
        << '}';
}
