package ru.yandex.solomon;

import org.junit.Test;

import static java.nio.charset.StandardCharsets.UTF_8;
import static org.junit.Assert.assertEquals;

public class JavaStrHashTest {

    private static void testHashes(String str) {
        int h1 = str.hashCode();
        int h2 = JavaStrNative.hash(str.getBytes(UTF_8));
        assertEquals("invalid hash for \'" + str + '\'', h1, h2);
    }

    @Test
    public void hash() {
        testHashes("hello");
        testHashes("привет");
        testHashes("مرحبا");
        testHashes("สวัสดี");
        testHashes("你好");
        testHashes("こんにちは");
        testHashes("hellо мир");
        testHashes("привет world");
    }
}
