package ru.yandex.solomon.name.resolver;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.config.protobuf.name.resolver.TNameResolverConfig;
import ru.yandex.solomon.main.SpringContexts;
import ru.yandex.solomon.name.resolver.spring.NameResolverContext;
import ru.yandex.solomon.secrets.SecretProviders;

import static ru.yandex.solomon.config.SolomonConfigs.parseConfigWithoutInclude;

/**
 * @author Alexey Trushkin
 */
@RunWith(Parameterized.class)
public class NameResolverMainContextTest {

    @Rule
    public Timeout timeout = Timeout.builder()
            .withLookingForStuckThread(true)
            .withTimeout(1, TimeUnit.MINUTES)
            .build();

    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
                "configs/testing/name-resolver.conf",
                "configs/prestable/name-resolver.conf",
                "configs/production/name-resolver.vla.conf",
                "configs/production/name-resolver.sas.conf",
                "configs/cloud-preprod/name-resolver.conf",
                "configs/cloud-prod/name-resolver.sas.conf",
                "configs/cloud-prod/name-resolver.vla.conf",
                "configs/israel/name-resolver.a.conf",
                "configs/israel/name-resolver.b.conf",
        };
    }

    @Test
    public void testConfiguration() {
        if (!Files.exists(Path.of(configFile))) {
            Assert.fail("cannot find file " + configFile + ", CWD: " + Path.of(".").toAbsolutePath().normalize());
        }

        var config = parseConfigWithoutInclude(configFile, TNameResolverConfig.getDefaultInstance());
        Assert.assertNotEquals(TNameResolverConfig.getDefaultInstance(), config);

        try (var ctx = SpringContexts.createWeb(NameResolverContext.class, config, SecretProviders.empty())) {
            Assert.assertEquals(config, ctx.getBean(TNameResolverConfig.class));
        }
    }
}
