package ru.yandex.solomon.name.resolver;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.name.resolver.stats.ByResource;
import ru.yandex.solomon.name.resolver.stats.ReceiveMetrics;
import ru.yandex.solomon.name.resolver.stats.ResourceUpdateStats;

/**
 * @author Vladimir Gordiychuk
 */
public class GlobalShardMetrics {
    public final ByResource<ReceiveMetrics> receive = new ByResource<>(key -> new ReceiveMetrics(key.toLabels()));
    private final MetricRegistry registry;
    public final Rate errors;

    public GlobalShardMetrics() {
        this.registry = new MetricRegistry();
        this.errors = registry.rate("nameResolver.shard.errors");
    }

    public void add(ResourceUpdateStats update) {
        for (var entry : update.statsByKey.entrySet()) {
            var key = entry.getKey();
            var stats = entry.getValue();
            receive.get(key).add(stats);
            receive.get(key.aggrType()).add(stats);
            receive.get(key.aggr()).add(stats);
        }
    }

    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        for (var metrics : receive.byKey.values()) {
            metrics.append(tsMillis, commonLabels, consumer);
        }
        registry.append(tsMillis, commonLabels, consumer);
    }
}
