package ru.yandex.solomon.name.resolver;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.solomon.balancer.AssignmentSeqNo;
import ru.yandex.solomon.name.resolver.db.ResourcesDao;

/**
 * @author Vladimir Gordiychuk
 */
public class NameResolverShardFactoryImpl implements NameResolverShardFactory {
    private final ResourcesDao resourcesDao;
    private final IssueTracker issueTracker;
    private final ExecutorService executor;
    private final ScheduledExecutorService timer;
    private final GlobalShardMetrics metrics;

    public NameResolverShardFactoryImpl(ResourcesDao resourcesDao, IssueTracker issueTracker, ExecutorService executor, GlobalShardMetrics metrics, ScheduledExecutorService timer) {
        this.resourcesDao = resourcesDao;
        this.executor = executor;
        this.timer = timer;
        this.metrics = metrics;
        this.issueTracker = issueTracker;
    }

    @Override
    public NameResolverShard create(String cloudId, AssignmentSeqNo seqNo) {
        return new NameResolverShard(cloudId, seqNo, resourcesDao, issueTracker, metrics, executor, timer);
    }
}
