package ru.yandex.solomon.name.resolver;

import it.unimi.dsi.fastutil.objects.Object2LongMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.meter.Meter;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.name.resolver.stats.ByResource;
import ru.yandex.solomon.name.resolver.stats.CountMetrics;
import ru.yandex.solomon.name.resolver.stats.ResourceKey;
import ru.yandex.solomon.name.resolver.stats.ResourceUpdateStats;

/**
 * @author Vladimir Gordiychuk
 */
public class NameResolverShardMetrics {
    private final GlobalShardMetrics global;
    private final MetricRegistry registry;
    public final Rate errors;
    public final GaugeInt64 resources;
    public final ByResource<CountMetrics> countMetrics = new ByResource<>(key -> new CountMetrics(key.toLabels()));

    public volatile long lastErrorInstant = 0;
    public final Meter cpuTimeNanos;
    public final long createdAtMs = System.currentTimeMillis();

    public NameResolverShardMetrics(String shardId, GlobalShardMetrics global) {
        this.global = global;
        registry = new MetricRegistry(Labels.of("shardId", shardId));
        errors = registry.rate("nameResolver.shard.errors");
        resources = registry.gaugeInt64("nameResolver.shard.resources");
        cpuTimeNanos = registry.fifteenMinutesMeter("nameResolver.shard.cpuTimeNanos");
    }

    void add(ResourceUpdateStats stats) {
        for (var entry : stats.statsByKey.entrySet()) {
            countMetrics.get(entry.getKey()).add(entry.getValue());
        }
        global.add(stats);
    }

    void obsolete(Object2LongMap<ResourceKey> obsolete) {
        for (var entry : obsolete.object2LongEntrySet()) {
            countMetrics.get(entry.getKey()).countObsolete.set(entry.getLongValue());
        }
    }

    void error() {
        errors.inc();
        global.errors.inc();
        lastErrorInstant = System.currentTimeMillis();
    }

    public long uptimeMillis() {
        return System.currentTimeMillis() - createdAtMs;
    }
}
