package ru.yandex.solomon.name.resolver;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.name.resolver.client.FindRequest;
import ru.yandex.solomon.name.resolver.client.FindResponse;
import ru.yandex.solomon.name.resolver.client.ResolveRequest;
import ru.yandex.solomon.name.resolver.client.ResolveResponse;
import ru.yandex.solomon.name.resolver.client.Resource;

/**
 * @author Vladimir Gordiychuk
 */
public interface ResourceService {
    CompletableFuture<Void> updateResources(String shardId, List<Resource> resources, boolean removeOtherOfService, String serviceProviderId);

    CompletableFuture<FindResponse> find(FindRequest request);

    CompletableFuture<ResolveResponse> resolve(ResolveRequest request);
}
