package ru.yandex.solomon.name.resolver;

import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.solomon.core.db.model.ServiceProvider;

/**
 * @author Vladimir Gordiychuk
 */
public class ServiceProviderHolderImpl implements ServiceProviderHolder, ServiceProviderListener {
    private volatile Map<String, ServiceProvider> snapshot;

    @Nullable
    @Override
    public Map<String, ServiceProvider> get() {
        return snapshot;
    }

    @Override
    public void onUpdateServiceProviders(Map<String, ServiceProvider> serviceProviderById) {
        this.snapshot = serviceProviderById;
    }
}
