package ru.yandex.solomon.name.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.solomon.core.db.model.ServiceProvider;

/**
 * @author Vladimir Gordiychuk
 */
public class ServiceProviders {
    private final Map<String, ServiceProvider> serviceProviderById;

    public ServiceProviders(Collection<ServiceProvider> serviceProviders) {
        var map = new HashMap<String, ServiceProvider>();
        for (var sp : serviceProviders) {
            map.put(sp.getId(), sp);
        }
        serviceProviderById = map;
    }

    @Nullable
    public ServiceProvider get(String id) {
        return serviceProviderById.get(id);
    }
}
