package ru.yandex.solomon.name.resolver.db.ydb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Consumer;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.ydb.table.result.ResultSetReader;

import ru.yandex.solomon.name.resolver.client.Resource;
import ru.yandex.solomon.name.resolver.db.ydb.YdbResourcesTable.ColumnReader;
import ru.yandex.solomon.name.resolver.index.ResourceInterner;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbResourcesReader implements Consumer<ResultSetReader> {
    private final ResourceInterner interner;
    private final ObjectMapper objectMapper;
    final ArrayList<Resource> resources = new ArrayList<>();
    @Nullable
    Resource last;

    public YdbResourcesReader(ResourceInterner interner, ObjectMapper objectMapper) {
        this.interner = interner;
        this.objectMapper = objectMapper;
    }

    @Override
    public void accept(ResultSetReader resultSet) {
        int rowCount = resultSet.getRowCount();
        if (rowCount == 0) {
            return;
        }

        resources.ensureCapacity(resources.size() + rowCount);

        var columns = new ColumnReader(resultSet, objectMapper);
        while (resultSet.next()) {
            var resource = new Resource();
            try {
                columns.read(resource, resultSet);
            } catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            last = interner.intern(resource);
            resources.add(last);
        }
    }
}
