package ru.yandex.solomon.name.resolver.handler;

import io.grpc.stub.StreamObserver;

import ru.yandex.solomon.name.resolver.ResourceService;
import ru.yandex.solomon.name.resolver.client.grpc.Proto;
import ru.yandex.solomon.name.resolver.protobuf.UpdateResourcesRequest;
import ru.yandex.solomon.name.resolver.protobuf.UpdateResourcesResponse;

import static ru.yandex.grpc.utils.StreamObservers.asyncComplete;

/**
 * @author Vladimir Gordiychuk
 */
public class UpdateResourcesHandler {
    private final ResourceService service;

    public UpdateResourcesHandler(ResourceService service) {
        this.service = service;
    }

    public void updateResources(UpdateResourcesRequest request, StreamObserver<UpdateResourcesResponse> responseObserver) {
        var req = Proto.fromProto(request);
        var future = service.updateResources(req.cloudId, req.resources, req.removeOther, req.serviceProviderId)
                .thenApply(ignore -> UpdateResourcesResponse.getDefaultInstance());
        asyncComplete(future, responseObserver);
    }
}
