package ru.yandex.solomon.name.resolver.index;

import java.util.Iterator;
import java.util.NoSuchElementException;

import ru.yandex.solomon.name.resolver.client.Resource;

/**
 * @author Vladimir Gordiychuk
 */
public class LevelsArrayIterator implements Iterator<Resource> {
    private final LevelsArray array;
    private int levelIdx = 0;
    private Iterator<Resource> levelIt;
    private Resource next;

    public LevelsArrayIterator(LevelsArray array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        if (next != null) {
            return true;
        }

        while (levelIdx < array.count()) {
            if (levelIt == null) {
                levelIt = array.getLevel(levelIdx).iterator();
            }

            while (levelIt.hasNext()) {
                var resource = levelIt.next();
                if (!hasOnPrevLevels(resource)) {
                    next = resource;
                    return true;
                }
            }

            levelIt = null;
            levelIdx++;
        }

        return false;
    }

    @Override
    public Resource next() {
        if (next == null) {
            throw new NoSuchElementException();
        }

        try {
            return next;
        } finally {
            next = null;
        }
    }

    private boolean hasOnPrevLevels(Resource resource) {
        for (int index = 0; index < levelIdx; index++) {
            if (array.getLevel(index).has(resource.resourceId)) {
                return true;
            }
        }
        return false;
    }
}
