package ru.yandex.solomon.name.resolver.index;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;


/**
 * Extends from CompletableFuture to reduce allocations a little bit
 *
 * @author Sergey Polovko
 */
final class RemoveRequest extends CompletableFuture<Void> implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(RemoveRequest.class);

    private final Collection<String> resourceIds;

    RemoveRequest(Collection<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public Collection<String> getResourceIds() {
        return resourceIds;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + MemoryCounter.arraySize(resourceIds.size(), MemoryCounter.OBJECT_POINTER_SIZE);
    }
}
