package ru.yandex.solomon.name.resolver.index;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.solomon.name.resolver.client.Resource;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceInternerImpl implements ResourceInterner {
    public static final ResourceInterner INSTANCE = new ResourceInternerImpl();

    private final Interner<String> weak = Interners.newWeakInterner();

    public ResourceInternerImpl() {
    }

    @Override
    public Resource intern(Resource resource) {
        resource.cloudId = intern(resource.cloudId);
        resource.folderId = intern(resource.folderId);
        resource.service = intern(resource.service);
        resource.type = intern(resource.type);
        return resource;
    }

    private String intern(String str) {
        return weak.intern(str);
    }
}
