package ru.yandex.solomon.name.resolver.index;

import java.util.Iterator;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;
import ru.yandex.solomon.name.resolver.client.Resource;
import ru.yandex.solomon.name.resolver.client.ResourceLabels;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceLabelsIterator implements Iterator<Labels> {
    private final Iterator<Resource> it;
    private final LabelsBuilder builder = new LabelsBuilder(6);

    public ResourceLabelsIterator(Iterator<Resource> it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        return it.hasNext();
    }

    @Override
    public Labels next() {
        var resource = it.next();
        builder.add(ResourceLabels.FOLDER_ID, resource.folderId);
        builder.add(ResourceLabels.SERVICE, resource.service);
        builder.add(ResourceLabels.TYPE, resource.type);
        builder.add(ResourceLabels.RESOURCE, resource.getNameOrId());
        builder.add(ResourceLabels.ID, resource.resourceId);
        builder.add(ResourceLabels.NAME, resource.name);
        builder.add(ResourceLabels.SEVERITY, resource.severity.name());
        return builder.build();
    }
}
