package ru.yandex.solomon.name.resolver.index;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.name.resolver.client.Resource;

/**
 * @author Vladimir Gordiychuk
 */
public interface ResourcesCollection extends Iterable<Resource>, MemMeasurable, AutoCloseable {
    Resource getOrNull(String resourceId);

    boolean has(String resourceId);

    CompletableFuture<Void> put(Resource resource);

    CompletableFuture<Void> putAll(Collection<Resource> resources);

    CompletableFuture<Void> removeAll(Collection<String> resourceIds);

    Stream<Resource> search(Selectors selectors);

    int size();
}
