package ru.yandex.solomon.name.resolver.index;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.solomon.name.resolver.client.Resource;


/**
 * Extends from CompletableFuture to reduce allocations a little bit
 *
 * @author Sergey Polovko
 */
final class UpdateRequest extends CompletableFuture<Void> implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(UpdateRequest.class);

    private final Collection<Resource> resources;

    UpdateRequest(Collection<Resource> resources) {
        this.resources = resources;
    }

    UpdateRequest(Resource resource) {
        this.resources = List.of(resource);
    }


    public Collection<Resource> getResources() {
        return resources;
    }

    public int size() {
        return resources.size();
    }

    @Override
    public long memorySizeIncludingSelf() {
        long size = SELF_SIZE;
        size += MemoryCounter.arraySize(resources.size(), MemoryCounter.OBJECT_POINTER_SIZE);
        return size;
    }
}
