package ru.yandex.solomon.name.resolver.logbroker;

import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.Message;

/**
 * @author Vladimir Gordiychuk
 */
public class PersqueueSubscriberMetrics {
    private static final String PREFIX = "persqueue.subscriber";
    public final GaugeInt64 demand;
    public final GaugeInt64 uncommittedLimit;
    public final Rate errors;
    private final PartitionStreamMetrics partitionStreamMetrics;

    public PersqueueSubscriberMetrics(MetricRegistry registry) {
        this.demand = registry.gaugeInt64(PREFIX + ".demand");
        this.errors = registry.rate(PREFIX + ".errors");
        this.uncommittedLimit = registry.gaugeInt64(PREFIX + ".uncommittedMessageLimit");
        this.partitionStreamMetrics = new PartitionStreamMetrics(PREFIX, registry);
    }

    public PartitionStreamMetrics.Metrics receiveMessage(Message message) {
        var metrics = partitionStreamMetrics.get(message.getPartitionStream().getKey());
        metrics.receiveMessage(message);
        return metrics;
    }

    public void assign(PartitionStream partitionStream) {
        partitionStreamMetrics.get(partitionStream.getKey());
    }

    public void unassign(PartitionStream partitionStream) {
        partitionStreamMetrics.remove(partitionStream.getKey());
    }

    public void unassignAll() {
        partitionStreamMetrics.removeAll();
    }

    public long uncommittedMessage() {
        return partitionStreamMetrics.uncommittedMessage();
    }
}
