package ru.yandex.solomon.name.resolver.logbroker;

import java.time.Instant;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.name.resolver.client.Resource;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceFormat {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String resourceToJson(Resource resource) {
        try {
            var root = resourceToNode(resource);
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(root);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectNode resourceToNode(Resource resource) {
        var root = MAPPER.createObjectNode()
                .put("cloud_id", resource.cloudId)
                .put("folder_id", resource.folderId)
                .put("service", resource.service)
                .put("resource_type", resource.type)
                .put("resource_id", resource.resourceId)
                .put("timestamp", formatTime(resource.updatedAt))
                .put("name", Nullables.orEmpty(resource.name));

        if (resource.deletedAt != 0) {
            root.put("deleted", formatTime(resource.deletedAt));
        }

        if (resource.reindexAt != 0) {
            root.put("reindex_timestamp", formatTime(resource.reindexAt));
        }

        return root;
    }

    private static String formatTime(long millis) {
        return Instant.ofEpochMilli(millis).toString();
    }
}
