package ru.yandex.solomon.name.resolver.sink;

import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class ShardSinkMetrics {
    final Rate errors;
    final GaugeInt64 shardCount;
    final GaugeInt64 resourceInFlight;
    final GaugeInt64 queueSize;

    public ShardSinkMetrics(MetricRegistry registry) {
        errors = registry.rate("shardSink.errors");
        shardCount = registry.gaugeInt64("shardSink.count");
        resourceInFlight = registry.gaugeInt64("shardSink.resource.inFlight");
        queueSize = registry.gaugeInt64("shardSink.resource.queue.size");
    }
}
