package ru.yandex.solomon.name.resolver.spring;

import java.util.List;

import javax.annotation.WillClose;

import io.grpc.BindableService;
import io.grpc.Server;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.grpc.utils.GrpcServerFactory;
import ru.yandex.grpc.utils.server.ServerMetrics;
import ru.yandex.grpc.utils.server.interceptors.ClientFilterServerInterceptor;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.rpc.TGrpcServerConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class GrpcServerContext implements DisposableBean {

    private final ThreadPoolProvider threads;
    private final MetricRegistry registry;

    @WillClose
    private Server server;

    public GrpcServerContext(ThreadPoolProvider threads, MetricRegistry registry) {
        this.threads = threads;
        this.registry = registry;
    }

    @Bean
    public ServerMetrics grpcServerMetrics() {
        return new ServerMetrics();
    }

    @Bean
    public ClientFilterServerInterceptor grpcClientFilter() {
        return new ClientFilterServerInterceptor();
    }

    @Bean
    public GrpcServerFactory grpcServerFactory(ServerMetrics metrics, ClientFilterServerInterceptor filter) {
        return new GrpcServerFactory(threads, metrics, filter);
    }

    @Bean
    public Server grpcServer(TGrpcServerConfig config, GrpcServerFactory factory, List<BindableService> services) {
        String prefix = "RpcServerConfig";
        server = factory.makeServer(prefix, config, services);
        factory.startWithTimeout(config, server);
        return server;
    }

    @Override
    public void destroy() {
        if (server != null) {
            server.shutdown();
        }
    }
}
