package ru.yandex.solomon.name.resolver.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.logbroker.agent.client.Client;
import ru.yandex.logbroker.agent.client.SessionMetrics;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.name.resolver.TIssueTrackerConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.name.resolver.IssueTracker;
import ru.yandex.solomon.name.resolver.IssueTrackerImpl;
import ru.yandex.solomon.name.resolver.IssueTrackerNoop;
import ru.yandex.solomon.spring.ConditionalOnBean;
import ru.yandex.solomon.spring.ConditionalOnMissingBean;
import ru.yandex.solomon.unified.agent.UnifiedAgentClients;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class IssueTrackerContext {

    private final ThreadPoolProvider threads;
    private final MetricRegistry registry;

    public IssueTrackerContext(ThreadPoolProvider threads, MetricRegistry registry) {
        this.threads = threads;
        this.registry = registry;
    }

    @Bean
    @ConditionalOnBean(TIssueTrackerConfig.class)
    protected Client client(TIssueTrackerConfig config) {
        return UnifiedAgentClients.makeClient(config.getUnifiedAgentClient(), threads, registry);
    }

    @Bean
    @ConditionalOnBean(TIssueTrackerConfig.class)
    public IssueTracker tracker(Client client) {
        var session = client.newSession()
                .setMetrics(new SessionMetrics(registry.subRegistry("session", "issue-tracker")))
                .build();

        return new IssueTrackerImpl(session);
    }

    @Bean
    @ConditionalOnMissingBean(TIssueTrackerConfig.class)
    public IssueTracker noopIssueTracker() {
        return new IssueTrackerNoop();
    }
}
