package ru.yandex.solomon.name.resolver.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.cluster.discovery.ClusterDiscovery;
import ru.yandex.grpc.utils.GrpcTransport;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.locks.DistributedLock;
import ru.yandex.solomon.name.resolver.sink.ShardSinkClient;
import ru.yandex.solomon.name.resolver.sink.ShardSinkClientImpl;
import ru.yandex.solomon.name.resolver.sink.ShardSinkDispatcher;
import ru.yandex.solomon.name.resolver.sink.ShardSinkMetrics;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class SinkContext {
    private final ThreadPoolProvider threads;
    private final MetricRegistry registry;

    public SinkContext(ThreadPoolProvider threads, MetricRegistry registry) {
        this.threads = threads;
        this.registry = registry;
    }

    @Bean
    public ShardSinkClient shardSinkClient(DistributedLock lock, ClusterDiscovery<GrpcTransport> discovery) {
        return new ShardSinkClientImpl(lock, discovery);
    }

    @Bean
    public ShardSinkDispatcher shardSinkDispatcher(ShardSinkClient client) {
        var executor = threads.getExecutorService("CpuLowPriority", "");
        var timer = threads.getIOExecutor();
        return new ShardSinkDispatcher(client, executor, timer, new ShardSinkMetrics(registry));
    }
}
