package ru.yandex.solomon.name.resolver.spring;

import java.util.concurrent.ExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.cloud.token.IamTokenClient;
import ru.yandex.cloud.token.IamTokenClientOptions;
import ru.yandex.cloud.token.grpc.GrpcIamTokenClient;
import ru.yandex.solomon.config.protobuf.TIamTokenClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.spring.ConditionalOnBean;
import ru.yandex.solomon.ydb.YdbAuthProviders;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class YdbAuthContext {
    private final ThreadPoolProvider threads;

    public YdbAuthContext(ThreadPoolProvider threads) {
        this.threads = threads;
    }

    @Bean
    @ConditionalOnBean(TIamTokenClientConfig.class)
    public IamTokenClient iamTokenClient(TIamTokenClientConfig config) {
        ExecutorService executor = threads.getExecutorService(
                config.getThreadPoolName(),
                "IamTokenClient.ThreadPoolName");

        return new GrpcIamTokenClient(IamTokenClientOptions.forAddress(config.getHost(), config.getPort())
                .withHandlerExecutor(executor)
                .withUserAgent("SolomonNameResolver"));
    }

    @Bean
    @ConditionalOnBean(TIamTokenClientConfig.class)
    public YdbAuthProviders ydbAuthProviders(IamTokenClient iamTokenClient, SecretProvider secrets) {
        return new YdbAuthProviders(iamTokenClient, threads, secrets);
    }
}
