package ru.yandex.solomon.name.resolver.stats;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

/**
 * @author Vladimir Gordiychuk
 */
public class ByResource<T> {
    public ConcurrentMap<ResourceKey, T> byKey;
    private final Function<ResourceKey, T> create;

    public ByResource(Function<ResourceKey, T> create) {
        this.byKey = new ConcurrentHashMap<>();
        this.create = create;
    }

    public T get(ResourceKey key) {
        return byKey.computeIfAbsent(key, create);
    }
}
