package ru.yandex.solomon.name.resolver.stats;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class CountDistributionMetrics implements MetricSupplier {
    public final Histogram countAlive;
    public final Histogram countDeleted;
    public final Histogram countTotal;

    private final MetricRegistry registry;

    public CountDistributionMetrics(Labels labels) {
        this.registry = new MetricRegistry(labels);
        this.countAlive = registry.histogramCounter("nameResolver.resource.count.distribution", Labels.of("state", "alive"),
                Histograms.exponential(30, 2));
        this.countDeleted = registry.histogramCounter("nameResolver.resource.count.distribution", Labels.of("state", "deleted"),
                Histograms.exponential(30, 2));
        this.countTotal = registry.histogramCounter("nameResolver.resource.count.distribution", Labels.of("state", "total"),
                Histograms.exponential(30, 2));
    }

    public void add(CountMetrics metrics) {
        countAlive.record(metrics.countAlive.get());
        countDeleted.record(metrics.countDeleted.get());
        countTotal.record(metrics.countTotal.get());
    }

    @Override
    public int estimateCount() {
        return registry.estimateCount();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        registry.append(tsMillis, commonLabels, consumer);
    }
}
