package ru.yandex.solomon.name.resolver.stats;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class CountMetrics implements MetricSupplier {
    public final GaugeInt64 countAlive;
    public final GaugeInt64 countDeleted;
    public final GaugeInt64 countTotal;
    public final GaugeInt64 countObsolete;
    private final MetricRegistry registry;

    public CountMetrics(Labels labels) {
        this.registry = new MetricRegistry(labels);
        countAlive = registry.gaugeInt64("nameResolver.resource.count", Labels.of("state", "alive"));
        countDeleted = registry.gaugeInt64("nameResolver.resource.count", Labels.of("state", "deleted"));
        countTotal = registry.gaugeInt64("nameResolver.resource.count", Labels.of("state", "total"));
        countObsolete = registry.gaugeInt64("nameResolver.resource.obsolete.count");
    }

    public void add(ResourceStats stats) {
        countAlive.add(stats.countAlive);
        countDeleted.add(stats.countDeleted);
        countTotal.add(stats.countAlive + stats.countDeleted);
    }

    public void combine(CountMetrics metrics) {
        countAlive.combine(metrics.countAlive);
        countDeleted.combine(metrics.countDeleted);
        countTotal.combine(metrics.countTotal);
        countObsolete.combine(metrics.countObsolete);
    }

    @Override
    public int estimateCount() {
        return 4;
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        registry.append(tsMillis, commonLabels, consumer);
    }
}
