package ru.yandex.solomon.name.resolver.stats;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class ReceiveMetrics implements MetricSupplier {
    public final Rate receiveDelete;
    public final Rate receiveUpdate;
    public final Rate receiveAdd;
    public final Rate receiveObsolete;
    public final Rate receiveLost;
    public final Rate receiveReindex;
    public final Rate receiveRemoveFromDb;

    private final MetricRegistry registry;

    public ReceiveMetrics(Labels labels) {
        this.registry = new MetricRegistry();
        var prefix = "nameResolver";
        receiveDelete = registry.rate(prefix + ".resource.received.delete", labels);
        receiveUpdate = registry.rate(prefix + ".resource.received.update", labels);
        receiveAdd = registry.rate(prefix + ".resource.received.add", labels);
        receiveObsolete = registry.rate(prefix + ".resource.received.obsolete", labels);
        receiveLost = registry.rate(prefix + ".resource.received.lost", labels);
        receiveReindex = registry.rate(prefix + ".resource.received.reindex", labels);
        receiveRemoveFromDb = registry.rate(prefix + ".resource.received.removeFromDb", labels);
    }

    public void add(ResourceStats stats) {
        receiveAdd.add(stats.receiveAdd);
        receiveDelete.add(stats.receiveDelete);
        receiveUpdate.add(stats.receiveUpdate);
        receiveObsolete.add(stats.receiveObsolete);
        receiveLost.add(stats.receiveLost);
        receiveReindex.add(stats.receiveReindex);
        receiveRemoveFromDb.add(stats.receiveRemoveFromDb);
    }

    @Override
    public int estimateCount() {
        return registry.estimateCount();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        registry.append(tsMillis, commonLabels, consumer);
    }
}
