package ru.yandex.solomon.name.resolver.stats;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.name.resolver.client.Resource;

/**
 * @author Vladimir Gordiychuk
 */
public record ResourceKey(String service, String type) {
    private static final ResourceKey TOTAL = new ResourceKey("total", "total");

    public static ResourceKey of(Resource resource) {
        return new ResourceKey(resource.service, resource.type);
    }

    public Labels toLabels() {
        return Labels.of("serviceProvider", service, "type", type);
    }

    public ResourceKey aggrType() {
        return new ResourceKey(service, "total");
    }

    public ResourceKey aggr() {
        return TOTAL;
    }
}
