package ru.yandex.solomon.name.resolver.www;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.auth.http.HttpAuthenticator;
import ru.yandex.solomon.auth.internal.InternalAuthorizer;
import ru.yandex.solomon.name.resolver.NameResolverLocalShards;
import ru.yandex.solomon.staffOnly.RootLink;

/**
 * @author Vladimir Gordiychuk
 */
@RestController
public class ResourcesController {
    @Autowired
    private HttpAuthenticator authenticator;
    @Autowired
    private InternalAuthorizer authorizer;
    @Autowired
    private NameResolverLocalShards shards;

    @Bean
    public RootLink resourceLinks() {
        return new RootLink("/resources", "Resources");
    }

    @RequestMapping(value = "/resources", produces = MediaType.TEXT_HTML_VALUE)
    public CompletableFuture<String> stockpileLocalShards(ServerHttpRequest request, @RequestParam Map<String, String> params) {
        return authorize(request)
                .thenApply(account -> new ResourcesPage("/resources", params, shards).genString());
    }

    private CompletableFuture<Account> authorize(ServerHttpRequest request) {
        return authenticator.authenticate(request)
                .thenCompose(authSubject -> authorizer.authorize(authSubject));
    }

}
