package ru.yandex.solomon.name.resolver;

import java.util.concurrent.ForkJoinPool;

import ru.yandex.solomon.balancer.AssignmentSeqNo;
import ru.yandex.solomon.name.resolver.db.InMemoryResourceDao;
import ru.yandex.solomon.ut.ManualClock;
import ru.yandex.solomon.ut.ManualScheduledExecutorService;

/**
 * @author Vladimir Gordiychuk
 */
public class NameResolverShardFactoryStub implements NameResolverShardFactory, AutoCloseable {
    public final ManualClock clock;
    public final ManualScheduledExecutorService timer;
    public final InMemoryResourceDao resourceDao;
    public final GlobalShardMetrics metrics = new GlobalShardMetrics();

    public NameResolverShardFactoryStub() {
        clock = new ManualClock();
        timer = new ManualScheduledExecutorService(1, clock);
        resourceDao = new InMemoryResourceDao();
    }

    @Override
    public NameResolverShard create(String cloudId, AssignmentSeqNo seqNo) {
        var issueTracker = new IssueTrackerNoop();
        return new NameResolverShard(cloudId, seqNo, resourceDao, issueTracker, metrics, ForkJoinPool.commonPool(), timer);
    }

    @Override
    public void close() {
        timer.shutdownNow();
    }
}
