package ru.yandex.solomon.name.resolver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.Nullable;

import ru.yandex.solomon.core.db.model.ServiceProvider;

/**
 * @author Vladimir Gordiychuk
 */
public class ServiceProviderHolderStub implements ServiceProviderHolder {
    private final ConcurrentMap<String, ServiceProvider> providers = new ConcurrentHashMap<>();

    public void addProvider(ServiceProvider... providers) {
        for (var provider : providers) {
            this.providers.put(provider.getId(), provider);
        }
    }

    @Nullable
    @Override
    public Map<String, ServiceProvider> get() {
        return Map.copyOf(providers);
    }
}
