package ru.yandex.solomon.name.resolver.db;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Vladimir Gordiychuk
 */
public class InMemoryShardsDao implements ShardsDao {
    private final ConcurrentHashMap<String, String> shards = new ConcurrentHashMap<>();

    @Override
    public CompletableFuture<Void> createSchemaForTests() {
        return CompletableFuture.runAsync(() -> {});
    }

    @Override
    public CompletableFuture<Void> dropSchemaForTests() {
        return CompletableFuture.runAsync(shards::clear);
    }

    @Override
    public CompletableFuture<Void> insert(String shardId) {
        return CompletableFuture.runAsync(() -> shards.put(shardId, shardId));
    }

    @Override
    public CompletableFuture<Void> delete(String shardId) {
        return CompletableFuture.runAsync(() -> shards.remove(shardId));
    }

    @Override
    public CompletableFuture<List<String>> findAll() {
        return CompletableFuture.supplyAsync(() -> List.copyOf(shards.keySet()));
    }
}
