package ru.yandex.solomon.name.resolver.db.ydb;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;
import ru.yandex.solomon.name.resolver.db.ResourcesDao;
import ru.yandex.solomon.name.resolver.db.ResourcesDaoTest;

/**
 * @author Vladimir Gordiychuk
 */
@YaExternal
public class YdbResourcesDaoTest extends ResourcesDaoTest {
    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();
    private ResourcesDao dao;

    @Before
    public void setUp() {
        var ydb = new YdbHelper(kikimr, this.getClass().getSimpleName() + "_" + testName.getMethodName());
        var root = ydb.getRootPath();

        dao = new YdbResourcesDao(root, ydb.getTableClient(), ydb.getSchemeClient(), new ObjectMapper());
        dao.createSchemaForTests().join();
    }

    @Override
    public ResourcesDao getDao() {
        return dao;
    }
}
