package ru.yandex.solomon.name.resolver.db.ydb;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;
import ru.yandex.solomon.name.resolver.db.ShardsDao;
import ru.yandex.solomon.name.resolver.db.ShardsDaoTest;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbShardsDaoTest extends ShardsDaoTest {
    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();
    private ShardsDao ydbDao;

    @Before
    public void setUp() {
        var ydb = new YdbHelper(kikimr, this.getClass().getSimpleName() + "_" + testName.getMethodName());
        ydbDao = new YdbShardsDao(ydb.getRootPath(), ydb.getTableClient(), ydb.getSchemeClient());
        ydbDao.createSchemaForTests().join();
    }

    @Override
    public ShardsDao getDao() {
        return ydbDao;
    }
}
