package ru.yandex.solomon.name.resolver.index;

import java.util.List;
import java.util.concurrent.Executor;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.name.resolver.client.Resource;
import ru.yandex.solomon.util.concurrent.AutoresetEvent;


/**
 * The same collection as {@link ResourcesCollectionImpl} but with capability to wait
 * maintenance tasks running in the background.
 *
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class AwaitableResourcesCollection extends ResourcesCollectionImpl {
    private final AutoresetEvent actEvent = new AutoresetEvent();

    public AwaitableResourcesCollection(Executor executor, int[] levelsSizes, List<Resource> resources) {
        super("Awaitable", executor, levelsSizes, resources);
    }

    @Override
    protected void act() {
        super.act();
        actEvent.signal();
    }

    public void awaitActDone() {
        actEvent.await();
    }
}
