package ru.yandex.solomon.name.resolver.index;

import java.nio.charset.StandardCharsets;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static ru.yandex.solomon.name.resolver.client.ResourcesTestSupport.staticResource;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceInternerImplTest {

    private ResourceInterner interner;

    @Before
    public void setUp() throws Exception {
        interner = new ResourceInternerImpl();
    }

    @Test
    public void internData() {
        var result = interner.intern(staticResource());
        assertEquals(staticResource(), result);
    }

    @Test
    public void internService() {
        var left = staticResource().setService(new String("test".getBytes(StandardCharsets.UTF_8)));
        var right = staticResource().setService(new String("test".getBytes(StandardCharsets.UTF_8)));

        assertSame(interner.intern(left).service, interner.intern(right).service);
    }

    @Test
    public void internType() {
        var left = staticResource().setType(new String("disk".getBytes(StandardCharsets.UTF_8)));
        var right = staticResource().setType(new String("disk".getBytes(StandardCharsets.UTF_8)));

        assertSame(interner.intern(left).type, interner.intern(right).type);
    }

    @Test
    public void internFolder() {
        var left = staticResource().setFolderId(new String("my".getBytes(StandardCharsets.UTF_8)));
        var right = staticResource().setFolderId(new String("my".getBytes(StandardCharsets.UTF_8)));

        assertSame(interner.intern(left).folderId, interner.intern(right).folderId);
    }

    @Test
    public void internCloud() {
        var left = staticResource().setCloudId(new String("cloud".getBytes(StandardCharsets.UTF_8)));
        var right = staticResource().setCloudId(new String("cloud".getBytes(StandardCharsets.UTF_8)));

        assertSame(interner.intern(left).cloudId, interner.intern(right).cloudId);
    }

    @Test
    public void doNotInternResourceId() {
        var left = staticResource().setResourceId(new String("id".getBytes(StandardCharsets.UTF_8)));
        var right = staticResource().setResourceId(new String("id".getBytes(StandardCharsets.UTF_8)));

        assertSame(left.resourceId, interner.intern(left).resourceId);
        assertSame(right.resourceId, interner.intern(right).resourceId);
    }

    @Test
    public void doNotInternName() {
        var left = staticResource().setName(new String("name".getBytes(StandardCharsets.UTF_8)));
        var right = staticResource().setName(new String("name".getBytes(StandardCharsets.UTF_8)));

        assertSame(left.name, interner.intern(left).name);
        assertSame(right.name, interner.intern(right).name);
    }
}
