package ru.yandex.solomon.name.resolver.logbroker;

import java.util.concurrent.CountDownLatch;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.EventHandler;
import ru.yandex.persqueue.read.event.PartitionStreamCreateEvent;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamCreateEventStub implements PartitionStreamCreateEvent {
    public final PartitionStreamStub partitionStream;
    public final CountDownLatch confirmSync = new CountDownLatch(1);

    public PartitionStreamCreateEventStub(PartitionStreamStub partitionStream) {
        this.partitionStream = partitionStream;
    }

    @Override
    public void confirm() {
        confirmSync.countDown();
    }

    @Override
    public void confirm(long readOffset) {
        confirmSync.countDown();
    }

    @Override
    public void confirm(long readOffset, long commitOffset) {
        confirmSync.countDown();
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onPartitionStreamCreate(this);
    }
}
