package ru.yandex.solomon.name.resolver.logbroker;

import java.util.Map;
import java.util.concurrent.CountDownLatch;

import com.google.protobuf.ByteString;

import ru.yandex.persqueue.codec.Codec;
import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.EventHandler;
import ru.yandex.persqueue.read.event.Message;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamDataEventStub implements Message {
    private final PartitionStreamStub partitionStream;
    private final long offset;
    private final Codec codec;
    private final ByteString data;
    private final long createdAt = System.currentTimeMillis();

    public PartitionStreamDataEventStub(PartitionStreamStub partitionStream, long offset, Codec codec, ByteString data) {
        this.partitionStream = partitionStream;
        this.offset = offset;
        this.codec = codec;
        this.data = data;
    }

    @Override
    public ByteString getData() {
        return data;
    }

    @Override
    public Codec getCodec() {
        return codec;
    }

    @Override
    public long getOffset() {
        return offset;
    }

    @Override
    public long getSeqNo() {
        return 42 + offset;
    }

    @Override
    public long getCreateTimeMillis() {
        return createdAt;
    }

    @Override
    public Map<String, String> getExtraFields() {
        return Map.of();
    }

    @Override
    public void commit() {
        partitionStream.commit(offset);
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onMessage(this);
    }

    public CountDownLatch commitSync() {
        return partitionStream.commitSync(offset);
    }
}
