package ru.yandex.solomon.name.resolver.logbroker;

import java.util.concurrent.CountDownLatch;

import ru.yandex.persqueue.read.PartitionStream;
import ru.yandex.persqueue.read.event.EventHandler;
import ru.yandex.persqueue.read.event.PartitionStreamDestroyEvent;

/**
 * @author Vladimir Gordiychuk
 */
public class PartitionStreamDestroyEventStub implements PartitionStreamDestroyEvent {
    public final PartitionStreamStub partitionStream;
    public final CountDownLatch confirmSync = new CountDownLatch(1);

    public PartitionStreamDestroyEventStub(PartitionStreamStub partitionStream) {
        this.partitionStream = partitionStream;
    }

    @Override
    public PartitionStream getPartitionStream() {
        return partitionStream;
    }

    @Override
    public void visit(EventHandler handler) {
        handler.onPartitionStreamDestroy(this);
    }

    @Override
    public long getCommittedOffset() {
        return 42;
    }

    @Override
    public void confirm() {
        confirmSync.countDown();
    }
}
