package ru.yandex.solomon.name.resolver.logbroker;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static ru.yandex.solomon.name.resolver.client.ResourcesTestSupport.staticResource;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceValidatorTest {

    @Test
    public void valid() {
        assertNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource()));
        assertNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setName("")));
    }

    @Test
    public void invalidCloudId() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setCloudId("")));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setCloudId(null)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setCloudId(RandomStringUtils.random(1000))));
    }

    @Test
    public void invalidFolderId() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setFolderId("")));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setFolderId(null)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setFolderId(RandomStringUtils.random(1000))));
    }

    @Test
    public void invalidService() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setService("")));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setService(null)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setService(RandomStringUtils.random(1000))));
    }

    @Test
    public void invaliType() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setType("")));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setType(null)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setType(RandomStringUtils.random(1000))));
    }

    @Test
    public void invalidResourceId() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setResourceId("")));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setResourceId(null)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setResourceId(RandomStringUtils.random(1000))));
    }

    @Test
    public void invalidName() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setResourceId(RandomStringUtils.random(1000))));
    }

    @Test
    public void invalidUpdatedAt() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setUpdatedAt(0)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setUpdatedAt(1)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setUpdatedAt(Long.MAX_VALUE)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setUpdatedAt(Long.MIN_VALUE)));
    }

    @Test
    public void invalidDeletedAt() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setDeletedAt(1)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setDeletedAt(Long.MAX_VALUE)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setDeletedAt(Long.MIN_VALUE)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setUpdatedAt(System.currentTimeMillis() - 1_000).setDeletedAt(System.currentTimeMillis() + 1_000)));
    }

    @Test
    public void invalidReindexAt() {
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setReindexAt(1)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setReindexAt(Long.MAX_VALUE)));
        assertNotNull(ResourceValidator.STRICT_VALIDATOR.validate(staticResource().setReindexAt(Long.MIN_VALUE)));
    }
}
