package ru.yandex.solomon.project.manager.spring;

import java.nio.file.Files;
import java.nio.file.Path;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.config.protobuf.project.manager.ProjectManagerConfig;
import ru.yandex.solomon.main.SpringContexts;
import ru.yandex.solomon.secrets.SecretProviders;

import static ru.yandex.solomon.config.SolomonConfigs.parseConfigWithoutInclude;

/**
 * @author Alexey Trushkin
 */
@RunWith(Parameterized.class)
public class ProjectManagerContextTest {

    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
                "configs/prestable/project-manager.conf",
                "configs/testing/project-manager.conf",
                "configs/prestable/project-manager.conf",
                "configs/production/project-manager.conf",
                "configs/cloud-preprod/project-manager.conf",
                "configs/cloud-prod/project-manager.conf",
                "configs/israel/project-manager.conf",
        };
    }

    @Test
    public void testConfiguration() {
        if (!Files.exists(Path.of(configFile))) {
            Assert.fail("cannot find file " + configFile + ", CWD: " + Path.of(".").toAbsolutePath().normalize());
        }

        var config = parseConfigWithoutInclude(configFile, ProjectManagerConfig.getDefaultInstance());
        Assert.assertNotEquals(ProjectManagerConfig.getDefaultInstance(), config);

        try (var ctx = SpringContexts.createWeb(ProjectManagerContext.class, config, SecretProviders.empty())) {
            Assert.assertEquals(config, ctx.getBean(ProjectManagerConfig.class));
        }
    }
}
