package ru.yandex.solomon.project.manager.abc.db;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.project.manager.abc.AbcToProjectMapping;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface AbcToProjectMappingDao extends SchemaAwareDao {

    CompletableFuture<Optional<AbcToProjectMapping>> getMapping(String abcSlug);

    CompletableFuture<Void> setDefaultProject(AbcToProjectMapping mapping, String updatedBy);
}
