package ru.yandex.solomon.project.manager.abc.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
class YdbAbcToProjectMappingQuery {

    private static final String SELECT_ONE = """
            --!syntax_v1
            DECLARE $abcSlug AS Utf8;

            SELECT * FROM `TABLE` WHERE abcSlug = $abcSlug;
            """;

    private static final String UPSERT = """
            --!syntax_v1
            DECLARE $abcSlug AS Utf8;
            DECLARE $projectId AS Utf8;
            DECLARE $updatedAt AS Timestamp;
            DECLARE $updatedBy AS Utf8;

            UPSERT INTO `TABLE` (
              abcSlug,
              projectId,
              updatedAt,
              updatedBy
            )
            VALUES (
              $abcSlug,
              $projectId,
              $updatedAt,
              $updatedBy
            );
            """;

    final String root;
    final String table;
    final String upsert;
    final String selectOne;

    public YdbAbcToProjectMappingQuery(String root) {
        this.root = root;
        this.table = root + "/AbcToProjectMapping";
        this.selectOne = prepare(SELECT_ONE);
        this.upsert = prepare(UPSERT);
    }

    private String prepare(String query) {
        return query
                .replaceAll("TABLE", table);
    }
}
