package ru.yandex.solomon.project.manager.abc.db.ydb;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.core.Status;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.settings.AutoPartitioningPolicy;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.PartitioningPolicy;
import com.yandex.ydb.table.values.PrimitiveType;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
class YdbAbcToProjectMappingTable {

    static String ABC_SLUG = "abcSlug";
    static String PARAM_ABC_SLUG = "$" + ABC_SLUG;
    static String PROJECT_ID = "projectId";
    static String PARAM_PROJECT_ID = "$" + PROJECT_ID;
    static String UPDATED_AT = "updatedAt";
    static String PARAM_UPDATED_AT = "$" + UPDATED_AT;
    static String UPDATED_BY = "updatedBy";
    static String PARAM_UPDATED_BY = "$" + UPDATED_BY;

    static CompletableFuture<Status> createTable(String tablePath, Session session) {
        var table = TableDescription.newBuilder()
                .addNullableColumn(ABC_SLUG, PrimitiveType.utf8())
                .addNullableColumn(PROJECT_ID, PrimitiveType.utf8())
                .addNullableColumn(UPDATED_AT, PrimitiveType.timestamp())
                .addNullableColumn(UPDATED_BY, PrimitiveType.utf8())
                .setPrimaryKeys(ABC_SLUG)
                .build();

        var settings = new CreateTableSettings();
        settings.setPartitioningPolicy(new PartitioningPolicy().setAutoPartitioning(AutoPartitioningPolicy.AUTO_SPLIT_MERGE));
        settings.setTimeout(10, TimeUnit.SECONDS);

        return session.createTable(tablePath, table, settings);
    }
}

