package ru.yandex.solomon.project.manager.api;

import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.Context;

import ru.yandex.monitoring.api.v3.project.manager.Subject;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.dto.AccessDtoConverter;
import ru.yandex.solomon.auth.exceptions.AuthorizationException;
import ru.yandex.solomon.auth.grpc.AuthenticationInterceptor;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class WhiteListAuthorizer {
    private final Set<String> whiteList;

    public WhiteListAuthorizer(Set<String> whiteList) {
        this.whiteList = whiteList;
    }

    public Supplier<AuthSubject> authorizeSupplier(Subject callSubject) {
        return () -> {
            AuthSubject subject = AuthenticationInterceptor.getAuthSubject(Context.current());
            return authorize(subject, callSubject);
        };
    }

    public AuthSubject authorize(AuthSubject subject, Subject callSubject) {
        authorize(subject);
        return AccessDtoConverter.fromProto(callSubject);
    }

    public void authorize(AuthSubject subject) {
        var loginOptional = AuthSubject.getLogin(subject);
        var login = loginOptional.orElseThrow(() -> new AuthorizationException("You haven't permission for action"));
        if (!whiteList.contains(login)) {
            throw new AuthorizationException("You(" + login + ") haven't permission for action");
        }
    }
}
