package ru.yandex.solomon.project.manager.api.util;

import java.nio.charset.StandardCharsets;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ProtoJsonUtils {
    private static final JsonFormat.TypeRegistry typeRegistry = JsonFormat.TypeRegistry
            .newBuilder()
            .add(ru.yandex.monitoring.api.v3.project.manager.ProjectEntity.getDescriptor().getMessageTypes())
            .add(Empty.getDescriptor())
            .build();

    private static final JsonFormat.Printer prettyJsonPrinter = JsonFormat.printer()
            .usingTypeRegistry(typeRegistry)
            .includingDefaultValueFields();

    private static final JsonFormat.Printer jsonPrinter = prettyJsonPrinter.omittingInsignificantWhitespace();

    public static <T extends Message.Builder> void fromJson(byte[] body, T builder) {
        try {
            String json = new String(body, StandardCharsets.UTF_8);
            JsonFormat.parser().ignoringUnknownFields().merge(json, builder);
        } catch (InvalidProtocolBufferException e) {
            throw new BadRequestException("failed to parse request body: " + e.getMessage());
        }
    }

    public static String toJson(Message response, boolean pretty) {
        try {
            var printer = pretty ? prettyJsonPrinter : jsonPrinter;
            return printer.print(response);
        } catch (InvalidProtocolBufferException e) {
            throw new BadRequestException("failed to format response to JSON: " + e.getMessage());
        }
    }
}
