package ru.yandex.solomon.project.manager.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.project.manager.AuthorizeRequest;
import ru.yandex.monitoring.api.v3.project.manager.AuthorizeResponse;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesRequest;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesResponse;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface AccessService {
    CompletableFuture<AuthorizeResponse> authorize(AuthorizeRequest authorizeRequest, AuthSubject authSubject);

    CompletableFuture<AvailableResourcesResponse> availableResources(AvailableResourcesRequest availableResourcesRequest, AuthSubject authSubject);
}
