package ru.yandex.solomon.project.manager.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;

import ru.yandex.monitoring.api.v3.project.manager.CreateProjectRequest;
import ru.yandex.monitoring.api.v3.project.manager.DeleteProjectRequest;
import ru.yandex.monitoring.api.v3.project.manager.GetProjectRequest;
import ru.yandex.monitoring.api.v3.project.manager.ListProjectsRequest;
import ru.yandex.monitoring.api.v3.project.manager.ListProjectsResponse;
import ru.yandex.monitoring.api.v3.project.manager.Project;
import ru.yandex.monitoring.api.v3.project.manager.UpdateProjectRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface ProjectService {

    CompletableFuture<Project> get(GetProjectRequest request, AuthSubject subject);

    CompletableFuture<ListProjectsResponse> list(ListProjectsRequest request, AuthSubject subject);

    CompletableFuture<Project> create(CreateProjectRequest request, AuthSubject subject);

    CompletableFuture<Project> update(UpdateProjectRequest request, AuthSubject subject);

    CompletableFuture<Empty> delete(DeleteProjectRequest request, AuthSubject subject);
}
