package ru.yandex.solomon.project.manager.api.v3.intranet.grpc;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.monitoring.api.v3.project.manager.AbcProjectServiceGrpc;
import ru.yandex.monitoring.api.v3.project.manager.GetAbcDefaultProjectRequest;
import ru.yandex.monitoring.api.v3.project.manager.Project;
import ru.yandex.monitoring.api.v3.project.manager.SetAbcDefaultProjectRequest;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;
import ru.yandex.solomon.operation.OperationDtoConverter;
import ru.yandex.solomon.project.manager.api.v3.intranet.AbcToProjectMappingService;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcAbcToProjectMappingService  extends AbcProjectServiceGrpc.AbcProjectServiceImplBase implements GrpcService {

    private final AbcToProjectMappingService abcToProjectMappingService;
    private final OperationDtoConverter operationConverter;

    public GrpcAbcToProjectMappingService(Optional<AbcToProjectMappingService> abcToProjectMappingService) {
        this.abcToProjectMappingService = abcToProjectMappingService.orElse(null);
        operationConverter = new OperationDtoConverter();
    }

    @Override
    public void getDefaultProject(GetAbcDefaultProjectRequest request, StreamObserver<Project> responseObserver) {
        GrpcMethodHandler.handle(abcToProjectMappingService::getDefaultProjectForAbc, request, responseObserver);
    }

    @Override
    public void setDefaultProject(SetAbcDefaultProjectRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(abcToProjectMappingService::setDefaultProjectForAbc, request, responseObserver, operationConverter::wrap);
    }
}
